/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.client.render.umbrella;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.client.render.umbrella.UmbrellaModel;
import com.github.mim1q.convenientdecor.init.ModBlocks;
import com.github.mim1q.convenientdecor.init.ModEntityModelLayers;
import com.github.mim1q.convenientdecor.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class UmbrellaRenderer {
    public static final Map<DyeColor, ResourceLocation> TEXTURES = new HashMap<DyeColor, ResourceLocation>();
    private final ResourceLocation textureOverride;
    private final UmbrellaModel foldedModel;
    private final UmbrellaModel unfoldedModel;

    private UmbrellaRenderer(EntityModelSet loader) {
        this(loader, null);
    }

    private UmbrellaRenderer(EntityModelSet loader, ResourceLocation texture) {
        this.foldedModel = new UmbrellaModel(loader.m_171103_(ModEntityModelLayers.UMBRELLA_FOLDED));
        this.unfoldedModel = new UmbrellaModel(loader.m_171103_(ModEntityModelLayers.UMBRELLA_UNFOLDED));
        this.textureOverride = texture;
    }

    private UmbrellaRenderer(EntityModelSet loader, ModelLayerLocation foldedLayer, ModelLayerLocation unfoldedLayer, ResourceLocation texture) {
        this.foldedModel = new UmbrellaModel(loader.m_171103_(foldedLayer));
        this.unfoldedModel = new UmbrellaModel(loader.m_171103_(unfoldedLayer));
        this.textureOverride = texture;
    }

    public ResourceLocation getTexture(DyeColor color) {
        return this.textureOverride == null ? TEXTURES.get(color) : this.textureOverride;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, DyeColor color, boolean folded) {
        UmbrellaModel model = folded ? this.foldedModel : this.unfoldedModel;
        VertexConsumer consumer = vertexConsumers.m_6299_(model.m_103119_(this.getTexture(color)));
        model.m_7695_(matrices, consumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            TEXTURES.put(color, ConvenientDecor.id("textures/blockentity/umbrella/" + color.m_41065_() + ".png"));
        }
    }

    public static class UmbrellaRenderHelper {
        public static final ResourceLocation BROKEN_TEXTURE = ConvenientDecor.id("textures/blockentity/umbrella/broken.png");
        public static final ResourceLocation ALLERTS_UMBRELLA_TEXTURE = ConvenientDecor.id("textures/blockentity/umbrella/allert.png");
        private final UmbrellaRenderer defaultRenderer;
        private final UmbrellaRenderer brokenRenderer;
        private final UmbrellaRenderer allertsRenderer;

        public UmbrellaRenderHelper(EntityModelSet loader) {
            this.defaultRenderer = new UmbrellaRenderer(loader);
            this.brokenRenderer = new UmbrellaRenderer(loader, BROKEN_TEXTURE);
            this.allertsRenderer = new UmbrellaRenderer(loader, ModEntityModelLayers.ALLERTS_UMBRELLA_FOLDED, ModEntityModelLayers.ALLERTS_UMBRELLA_UNFOLDED, ALLERTS_UMBRELLA_TEXTURE);
        }

        public UmbrellaRenderer getRenderer(ItemStack stack) {
            if (stack.m_150930_((Item)ModItems.BROKEN_UMBRELLA)) {
                return this.brokenRenderer;
            }
            if (stack.m_150930_((Item)ModItems.ALLERTS_UMBRELLA)) {
                return this.allertsRenderer;
            }
            return this.defaultRenderer;
        }

        public UmbrellaRenderer getRenderer(BlockState state) {
            if (state.m_60713_((Block)ModBlocks.BROKEN_UMBRELLA)) {
                return this.brokenRenderer;
            }
            if (state.m_60713_((Block)ModBlocks.ALLERTS_UMBRELLA)) {
                return this.allertsRenderer;
            }
            return this.defaultRenderer;
        }
    }
}

